function [x,data,k] = Port_Arm(objfun,Q,h,x0,alpha_start)

% Parameters
MAXITER   = 50;
gamma = 0.5;
beta  = 0.8;
alpha_tol = 1e-10;

% save iterate information
data    = [];
data.x0 = x0;
data.x  = []; % iterates
data.d  = []; % search directions
data.g  = []; % gradients
data.f  = []; %function value
data.a  = []; %stepsize

% initial iterate should be feasible
xk = project_simplex(x0);

% print the header
printIter();

tic
for k = 1:MAXITER
    
    % compute function and gradient
    [f_k,g_k] = objfun(xk);

    % initial step size
    alpha_k = alpha_start;

    %linesearch by armijo backtracking

    xk1 = project_simplex(xk-alpha_k*g_k);
    d_k = xk1 - xk;

    

    f_k1 = objfun(xk1);
    
    while f_k1 > f_k + gamma*g_k'*(d_k) && alpha_k > alpha_tol

        % backstep alpha_k
        alpha_k = beta * alpha_k;

        % evaluate function at new iterate
        xk1 = project_simplex(xk-alpha_k*g_k);
        f_k1 = objfun(xk1);
        d_k = xk1 - xk;
    end

%     disp(g_k'*d_k) 
    
    
    % record the iterates
    if nargout >= 2
        data.x = [data.x,xk];
        data.d = [data.d,d_k];
        data.g = [data.g,g_k];
        data.f = [data.f;f_k];
        data.a = [data.a;alpha_k];
    end
    
    % update iterate
    xk = xk1;
    
    % print progress
    printIter(k, f_k, norm(d_k), alpha_k, toc);
    
    
end

x = xk;


end



function printIter(iter, f_k, d_k_norm, alpha_k, CPUtime)
% print the iteration progress

if nargin==0
% Store output header and footer strings as persistent variables
out_line = '================================================================================';
out_data = '   k       f     ||x^k - x^{k+1}||    alpha^k       CPU (s)';

% print algorithm output header
fprintf('\nBeginning gradient descent ...\n')
fprintf('%s\n%s\n%s\n', out_line, out_data, out_line)
return;
end

% Print iterate information
fprintf('% 4d  % .4e  % .4e    % .4e   % .5f\n',iter, f_k, d_k_norm, alpha_k, CPUtime);



end
